/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.menu;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.logger.PluginLogger;
import ec.gob.sri.dimm.ats.ui.asistentes.AsistenteConvertirATS;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class ConvertirATSHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell();
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        AsistenteConvertirATS asistente = new AsistenteConvertirATS();
        WizardDialog dialogoAsistenteValidar = new WizardDialog(shell, (IWizard)asistente);
        dialogoAsistenteValidar.setTitle("Convertir Anexo Transaccional");
        if (dialogoAsistenteValidar.open() == 0) {
            if (asistente.getErroresAts() != null) {
                IWorkbenchPage page = window.getActivePage();
                try {
                    page.openEditor((IEditorInput)asistente.getErroresAts(), "ec.gob.sri.dimm.ats.ui.editores.EditorErroresInformacionATS");
                }
                catch (PartInitException e) {
                    MessageDialog.openError((Shell)shell, (String)"Anexo Transaccional", (String)"Se ha producido un error al abrir el visor de errores de validaci\u00f3n.");
                    PluginLogger.logError((String)"Error al mostrar errores de validacion de informacion", (String)"ec.gob.sri.dimm.ats.ui", (Exception)((Object)e));
                }
            }
            if (!asistente.isTieneErrores()) {
                this.guardarAnexoDefinitivo(window.getShell(), asistente.getArchivoConvertido());
            }
        }
        return null;
    }

    protected void guardarAnexoDefinitivo(Shell shell, File archivoOrigen) {
        FileDialog saveDialog = new FileDialog(shell, 8192);
        saveDialog.setFilterNames(new String[]{"Archivos XML"});
        saveDialog.setFilterExtensions(new String[]{"*.xml"});
        saveDialog.setText("Guardar");
        saveDialog.setFileName("AT-.xml");
        String rutaFinal = saveDialog.open();
        if (!StringUtil.isNullOrEmpty((String)rutaFinal)) {
            File archivoFinal;
            String extension = "";
            if (!rutaFinal.toUpperCase().endsWith(".XML")) {
                extension = ".xml";
            }
            if ((archivoFinal = new File(String.valueOf(rutaFinal) + extension)).exists()) {
                if (MessageDialog.openConfirm((Shell)shell, (String)"Conversi\u00f3n de anexos", (String)"El archivo ya existe. \u00bfDesea sobreescribirlo?")) {
                    archivoFinal.delete();
                } else {
                    MessageDialog.openInformation((Shell)shell, (String)"Conversi\u00f3n de anexos", (String)"Exportaci\u00f3n cancelada.");
                    return;
                }
            }
            this.copiarAnexoFinal(archivoOrigen, archivoFinal);
            MessageDialog.openInformation((Shell)shell, (String)"Conversi\u00f3n de anexos", (String)"Archivo generado exitosamente.");
        }
    }

    private final void copiarAnexoFinal(File archivoOrigen, File archivoDestino) {
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            int length;
            inStream = new FileInputStream(archivoOrigen);
            outStream = new FileOutputStream(archivoDestino);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)inStream).read(buffer)) > 0) {
                ((OutputStream)outStream).write(buffer, 0, length);
            }
            ((InputStream)inStream).close();
            ((OutputStream)outStream).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

